;
;***********************
;   DEMO DISPLAY 8*8   *
;      EXPERIMENT 6    *
;***********************

           CPU "Z80.TBL"
           HOF "INT8"
           ORG 2000H

PSCAN:     EQU  0B1H
PDATA:     EQU  0B0H
PCTRL:     EQU  0B3H
BLOCK:     EQU  8*1
SCAN:      EQU  2
SYSCAL:    EQU  10H
SDISPY:    EQU  3FE7H
SYSFAG:    EQU  3FFDH
;
;
;***********************
;     MAIN PROGRAM     *
;***********************

MAIN:  LD   A,89H
       OUT  (PCTRL),A
;
       LD   BC,BLOCK       ;Clear buffer character
       LD   HL,DISBUF
       LD   DE,DISBUF+1
       LD   (HL),0
       LDIR
       CALL CLRDSP         ;Clear buffer screen
;
       CALL F_DISPY
       LD   HL,SYSFAG
       SETT 4,(HL)
MAIN0: LD   A,SCAN
       RST  SYSCAL
       CP   11H
       JR   Z,MAINR
       CP   13H
       JR   NZ,MAIN0
       CALL G_DEMO

;
;/* character ok for display */

MAINR: CALL GCHR           ;Change ascii for key to font display
MAIN1: CALL SHTL           ;LED shift left
       CALL SHTR           ;LED shift right
       CALL RTU            ;LED rotate up
       CALL RTD            ;LED rotate down
       CALL LDSP           ;LED display left
       CALL RDSP           ;LED display right
       JR   MAIN1

;
;/* Fill display buffer of 7 segment */
;
F_DISPY:
       LD   HL,TAB_DSP
       LD   DE,SDISPY
       LD   BC,6
       LDIR
       RET
;
;/* Get font of demo */
;
G_DEMO:
       LD   HL,TAB_DEM
       LD   DE,COMBUF
G_DEM: LD   A,(HL)
       LD   (DE),A
       OR   A
       INC  HL
       INC  DE
       JR   NZ,G_DEM
       RET

;***********************
; DISPLAY LEFT & RIGHT *
;***********************
;
DSP_LR:
       PUSH BC
       LD   B,0BH            ;repeat scan display 5 round
DSP_LR1:
       CALL SCAND
       DJNZ DSP_LR1
       POP  BC
       RET
;
;***********************
;      SCAN DISPLAY    *
;***********************

SCAND: PUSH AF
       PUSH BC
       PUSH HL

       LD   B,1          ;first row
SCD1:  LD   HL,DISPY
       LD   A,8            ;8 bit of column is convert
SC1:   RLC  (HL)           ;
       RL   C              ;data to convert
       DEC  A
       INC  HL
       JR   NZ,SC1
;
       LD   A,C            ;Next data
       OUT  (PDATA),A
       LD   A,B            ;Next scan
       OUT  (PSCAN),A
;
       CALL DEL_COL
       LD   A,0            ;Off scan
       OUT  (PSCAN),A
       RLC  B
       JR   NC,SCD1
;
       POP  HL
       POP  BC
       POP  AF
       RET

;
;***********************
;       DELAY SUB.     *
;***********************
;
DEL_COL:
       XOR  A
DELC1: NOP
       DEC  A
       JR   NZ,DELC1
       RET

;
;***********************
;   CLEAR DISPLAY BUF  *
;***********************
;
CLRDSP: LD  HL,DISPY
        LD  BC,BLOCK
        LD  DE,DISPY+1
        LD  (HL),0
        LDIR
        RET
;
;
;***********************
;   shift left display *
;***********************
;
SHTL:  CALL GLENT
       LD   IX,DISBUF
SHTL0: LD   D,0
       LD   HL,BLOCK
       OR   A
       SBC  HL,BC
       JR   NC,SHTL1
       LD   D,(IX+0)
;
SHTL1: LD   HL,DISPY+BLOCK-1
       PUSH BC
       LD   B,BLOCK
SHTL2: LD   A,(HL)
       LD   (HL),D
       LD   D,A
       DEC  HL
       DJNZ SHTL2
       CALL DSP_LR
       INC  IX
       POP  BC
       DEC  BC
       LD   A,B
       OR   C
       JR   NZ,SHTL0
       RET

;***********************
; shift right display  *
;***********************
;
SHTR:  LD   IX,DISBUF
       LD   DE,(BLENT)
       ADD  IX,DE
       DEC  IX
       CALL GLENT
;
SHTR0: LD   D,0
       LD   HL,BLOCK
       OR   A
       SBC  HL,BC
       JR   NC,SHTR1
       LD   D,(IX+0)
;
SHTR1: LD   HL,DISPY
       PUSH BC
       LD   B,BLOCK
SHTR2: LD   A,(HL)
       LD   (HL),D
       LD   D,A
       INC  HL
       DJNZ SHTR2
       CALL DSP_LR
       DEC  IX
       POP  BC
       DEC  BC
       LD   A,B
       OR   C
       JR   NZ,SHTR0
       RET
;
;***********************
;     GET  CHARECTER   *
;***********************

GCHR:  LD   IX,COMBUF
       LD   DE,DISBUF
GCHR1: LD   A,(IX+0)
       OR   A
       JR   Z,GCHRX
;
       SUB  20H
       LD   L,A
       LD   H,0
       ADD  HL,HL
       ADD  HL,HL
       ADD  HL,HL
;
       LD   BC,FONT
       ADD  HL,BC
       CALL FONT_COV
       LD   BC,8
       LDIR
;
       INC  IX
       JR   GCHR1
;
;/* Exit for get font */

GCHRX:
       PUSH IX
       POP  HL
       LD   BC,COMBUF
       OR   A
       SBC  HL,BC
       ADD  HL,HL
       ADD  HL,HL
       ADD  HL,HL
       LD   (BLENT),HL
       RET
;
;***********************
;       GET LENGTH     *
;***********************
;
GLENT: LD   HL,(BLENT)
       LD   DE,BLOCK
       ADD  HL,DE
       PUSH HL
       POP  BC
       RET
;
;***********************
;      FONT CONVERT    *
;***********************
;
FONT_COV:
       PUSH IY
       PUSH DE
       LD   DE,CHR_BUF
       LD   BC,8
       LDIR
;
       LD   IY,CHR_BUF1
       LD   B,8

FONT_1:
       LD   HL,CHR_BUF
       LD   C,8

FONT_2:
       RLC  (HL)
       RL   D
       INC  HL
       DEC  C
       JR   NZ,FONT_2

       LD   (IY+0),D
       INC  IY
       DJNZ FONT_1
       POP  DE
       POP  IY
       LD   HL,CHR_BUF1
       RET
;
;***********************
; LOAD CHARACTER TO DSP*
;***********************
;
LDIS:    LD  HL,DISBUF
         LD  BC,BLOCK
         LD  DE,DISPY
         LDIR
         RET
;
;***********************
;   rotate up display  *
;***********************
;
RTU:   CALL LDIS
       LD   C,8
RTU1:  LD   HL,DISPY
       LD   B,BLOCK
RTU2:  RLC  (HL)
       INC  HL
       DJNZ RTU2
       CALL DSP_UD
       DEC  C
       JR   NZ,RTU1
       RET
;
;***********************
;  rotate down display *
;***********************
;
RTD:   CALL LDIS
       LD   C,8
RTD1:  LD   HL,DISPY
       LD   B,BLOCK
RTD2:  RRC  (HL)
       INC  HL
       DJNZ RTD2
       CALL DSP_UD
       DEC  C
       JR   NZ,RTD1
       RET
;
;***********************
;   DISPLAY UP & DOWN  *
;***********************
;
DSP_UD:
       PUSH BC
       LD   B,20H          ;repeat scan display 22 round
DSP_UD1:
       CALL SCAND
       DJNZ DSP_UD1
       POP  BC
       RET
;

;***********************
; display left no shift*
;***********************
;
LDSP:  CALL CLRDSP
       LD   HL,DISBUF+BLOCK-1
       LD   DE,DISPY+BLOCK-1
       LD   B,BLOCK
LDSP1: LD   A,(HL)
       LD   (DE),A
       CALL DSP_LR
       DEC  HL
       DEC  DE
       DJNZ LDSP1
       RET

;***********************
;display right no shift*
;***********************
;
RDSP:  CALL CLRDSP
       LD   HL,DISBUF
       LD   DE,DISPY
       LD   B,BLOCK
RDSP1: LD   A,(HL)
       LD   (DE),A
       CALL DSP_LR
       INC  HL
       INC  DE
       DJNZ RDSP1
       RET
;
TAB_DSP:    DFB  77H,3EH,78H,5CH,40H,5EH
TAB_DEM:    DFB  "TEST",0
;

FONT:    DFB 00H,00H,00H,00H
         DFB 00H,00H,00H,00H    ;

         DFB 10H,10H,10H,10H
         DFB 00H,00H,10H,00H    ; !

         DFB 28H,28H,28H,00H
         DFB 00H,00H,00H,00H    ; "

         DFB 28H,28H,7CH,28H
         DFB 7CH,28H,28H,00H    ; #

         DFB 10H,3CH,50H,38H
         DFB 14H,78H,10H,00H    ; $

         DFB 60H,64H,08H,10H
         DFB 20H,4CH,0CH,00H    ; %

         DFB 30H,48H,50H,20H
         DFB 54H,48H,34H,00H    ; &

         DFB 30H,10H,20H,00H
         DFB 00H,00H,00H,00H    ; '

         DFB 08H,10H,20H,20H
         DFB 20H,10H,08H,00H    ; (

         DFB 20H,10H,08H,08H
         DFB 08H,10H,20H,00H    ; )

         DFB 00H,10H,54H,38H
         DFB 54H,10H,00H,00H    ; *

         DFB 00H,10H,10H,7CH
         DFB 10H,10H,00H,00H    ; +

         DFB 00H,00H,00H,00H
         DFB 30H,10H,20H,00H    ; ,

         DFB 00H,00H,00H,7CH
         DFB 00H,00H,00H,00H    ; -

         DFB 00H,00H,00H,00H
         DFB 00H,30H,30H,00H    ; .

         DFB 00H,04H,08H,10H
         DFB 20H,40H,00H,00H    ; /

         DFB 38H,44H,4CH,54H
         DFB 64H,44H,38H,00H    ; 0

         DFB 10H,30H,10H,10H
         DFB 10H,10H,38H,00H    ; 1

         DFB 38H,44H,04H,08H
         DFB 10H,20H,7CH,00H    ; 2

         DFB 7CH,08H,10H,08H
         DFB 04H,44H,38H,00H    ; 3

         DFB 08H,18H,28H,48H
         DFB 7CH,08H,08H,00H    ; 4

         DFB 7CH,40H,78H,04H
         DFB 04H,44H,38H,00H    ; 5

         DFB 18H,20H,40H,78H
         DFB 44H,44H,38H,00H    ; 6

         DFB 7CH,04H,08H,10H
         DFB 20H,20H,20H,00H    ; 7

         DFB 38H,44H,44H,38H
         DFB 44H,44H,38H,00H    ; 8

         DFB 38H,44H,44H,3CH
         DFB 04H,08H,30H,00H    ; 9

         DFB 00H,30H,30H,00H
         DFB 30H,30H,00H,00H    ; :

         DFB 00H,30H,30H,00H
         DFB 30H,10H,20H,00H    ; ;

         DFB 08H,10H,20H,40H
         DFB 20H,10H,08H,00H    ; <

         DFB 00H,00H,7CH,00H
         DFB 7CH,00H,00H,00H    ; =

         DFB 20H,10H,08H,04H
         DFB 08H,10H,20H,00H    ; >

         DFB 38H,44H,04H,08H
         DFB 10H,00H,10H,00H    ; ?

         DFB 38H,44H,04H,34H
         DFB 54H,54H,38H,00H    ; @

         DFB 38H,44H,44H,44H
         DFB 7CH,44H,44H,00H    ; A

         DFB 78H,44H,44H,78H
         DFB 44H,44H,78H,00H    ; B

         DFB 38H,44H,40H,40H
         DFB 40H,44H,38H,00H    ; C

         DFB 70H,48H,44H,44H
         DFB 44H,48H,70H,00H    ; D

         DFB 7CH,40H,40H,78H
         DFB 40H,40H,7CH,00H    ; E

         DFB 7CH,40H,40H,78H
         DFB 40H,40H,40H,00H    ; F

         DFB 38H,44H,40H,5CH
         DFB 44H,44H,3CH,00H    ; G

         DFB 44H,44H,44H,7CH
         DFB 44H,44H,44H,00H    ; H

         DFB 38H,10H,10H,10H
         DFB 10H,10H,38H,00H    ; I

         DFB 1CH,08H,08H,08H
         DFB 08H,48H,30H,00H    ; J

         DFB 44H,48H,50H,60H
         DFB 50H,48H,44H,00H    ; K

         DFB 40H,40H,40H,40H
         DFB 40H,40H,7CH,00H    ; L

         DFB 44H,6CH,54H,54H
         DFB 44H,44H,44H,00H    ; M

         DFB 44H,44H,64H,54H
         DFB 4CH,44H,44H,00H    ; N

         DFB 38H,44H,44H,44H
         DFB 44H,44H,38H,00H    ; O

         DFB 78H,44H,44H,78H
         DFB 40H,40H,40H,00H    ; P

         DFB 38H,44H,44H,44H
         DFB 54H,48H,34H,00H    ; Q

         DFB 78H,44H,44H,78H
         DFB 50H,48H,44H,00H    ; R

         DFB 3CH,40H,40H,38H
         DFB 04H,04H,78H,00H    ; S

         DFB 7CH,10H,10H,10H
         DFB 10H,10H,10H,00H    ; T

         DFB 44H,44H,44H,44H
         DFB 44H,44H,38H,00H    ; U

         DFB 44H,44H,44H,44H
         DFB 44H,28H,10H,00H    ; V

         DFB 44H,44H,44H,54H
         DFB 54H,54H,28H,00H    ; W

         DFB 44H,44H,28H,10H
         DFB 28H,44H,44H,00H    ; X

         DFB 44H,44H,44H,28H
         DFB 10H,10H,10H,00H    ; Y

         DFB 7CH,04H,08H,10H
         DFB 20H,40H,7CH,00H    ; Z

         DFB 38H,20H,20H,20H
         DFB 20H,20H,38H,00H    ; [

         DFB 40H,20H,10H,08H
         DFB 04H,02H,01H,00H    ; \

         DFB 38H,08H,08H,08H
         DFB 08H,08H,38H,00H    ; ]

         DFB 10H,28H,44H,00H
         DFB 00H,00H,00H,00H    ; ^

         DFB 00H,00H,00H,00H
         DFB 00H,00H,7CH,00H    ; _

         DFB 20H,10H,08H,00H
         DFB 00H,00H,00H,00H    ;`

         DFB 00H,00H,38H,08H
         DFB 38H,48H,34H,00H    ; a

         DFB 40H,40H,58H,64H
         DFB 44H,44H,78H,00H    ; b

         DFB 00H,00H,3CH,40H
         DFB 40H,40H,3CH,00H    ; c

         DFB 04H,04H,34H,4CH
         DFB 44H,44H,3CH,00H    ; d

         DFB 00H,00H,38H,44H
         DFB 78H,40H,38H,00H    ; e

         DFB 18H,24H,20H,70H
         DFB 20H,20H,20H,00H    ; f

         DFB 00H,00H,38H,44H
         DFB 44H,3CH,04H,38H    ; g

         DFB 40H,40H,58H,64H
         DFB 44H,44H,44H,00H    ; h

         DFB 10H,00H,30H,10H
         DFB 10H,10H,38H,00H    ; i

         DFB 00H,08H,00H,08H
         DFB 08H,28H,10H,00H    ; j

         DFB 40H,40H,48H,50H
         DFB 60H,50H,48H,00H    ; k

         DFB 30H,10H,10H,10H
         DFB 10H,10H,18H,00H    ; l

         DFB 00H,00H,68H,54H
         DFB 54H,54H,44H,00H    ; m

         DFB 00H,00H,58H,24H
         DFB 24H,24H,24H,00H    ; n

         DFB 00H,00H,38H,44H
         DFB 44H,44H,38H,00H    ; o

         DFB 00H,00H,70H,48H
         DFB 48H,70H,40H,40H    ; p

         DFB 00H,00H,38H,48H
         DFB 48H,38H,08H,08H    ; q

         DFB 00H,00H,58H,64H
         DFB 40H,40H,40H,00H    ; r

         DFB 00H,00H,38H,40H
         DFB 38H,04H,78H,00H    ; s

         DFB 20H,20H,78H,20H
         DFB 20H,24H,18H,00H    ; t

         DFB 00H,00H,48H,48H
         DFB 48H,48H,34H,00H    ; u

         DFB 00H,00H,44H,44H
         DFB 28H,28H,10H,00H    ; v

         DFB 00H,00H,44H,44H
         DFB 54H,54H,28H,00H    ; w

         DFB 00H,00H,44H,28H
         DFB 10H,28H,44H,00H    ; x

         DFB 00H,00H,48H,48H
         DFB 48H,38H,08H,70H    ; y

         DFB 00H,00H,7CH,08H
         DFB 10H,20H,7CH,00H    ; z

         DFB 08H,10H,10H,20H
         DFB 10H,10H,08H,00H    ; {

         DFB 18H,18H,18H,18H
         DFB 18H,18H,18H,00H    ; |

         DFB 20H,10H,10H,08H
         DFB 10H,10H,20H,00H    ; }

         DFB 00H,00H,00H,32H
         DFB 4CH,00H,00H,00H    ; ~

           ORG  2500H

COMBUF:    DFS   100
DISBUF:    DFS   8*100
DISPY:     DFS   BLOCK
CHR_BUF:   DFS   8
CHR_BUF1:  DFS   8
BLENT:     DFS   2
SPEED:     DFS   1
;
;

           END






